<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FrontController extends Controller
{
    public function index()
    {
        return view('front.index'); // This loads the home Blade view
    }
    public function examList()
    {
        return view('front.examList'); // This loads the home Blade view
    }
    public function examApply()
    {
        return view('front.examApply'); // This loads the home Blade view
    }


    // Handle the form submission
    public function saveApplication(Request $request)
    {
        // Validate form data
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|min:8|confirmed',
        ]);

        // If validation passes, process the form data (save to database or other logic)
        $user = ExamApplicants::create([
            'name' => $validatedData['name'],
            'email' => $validatedData['email'],
            'password' => bcrypt($validatedData['password']), // Encrypt password
        ]);
        return redirect()->route('application.print')->with('success', 'Application Has been  created successfully');
     
    }
}
