<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhatsAppService;

class WhatsAppController extends Controller
{
    protected $whatsapp;

    public function __construct(WhatsAppService $whatsapp)
    {
        $this->whatsapp = $whatsapp;
    }

    public function showForm()
    {
        return view('whatsapp.form');
    }

    public function send(Request $request)
    {
        $request->validate([
            'to' => 'required|string',
            'message' => 'required|string',
        ]);

        $response = $this->whatsapp->sendMessage($request->to, $request->message);

        return back()->with('status', 'Message sent! Response: ' . json_encode($response));
    }
}
