<?php
// ob_start();
// session_start();
// if (!isset($_SESSION['lid'])) {
    // header('Location: https://mphc.gov.in/law-clerk-cum-research-assistant-examination-2022');
// }
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title> High Court Recruitment </title>
        <link id="favicon" rel="shortcut icon" type="image/png" href="images/fevicon.jpg" />
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet" />
        <link href="css/styles.css" rel="stylesheet" />
        <style>
            .head {
                background-color: #ffffff !important;
                border-bottom: 7px solid #1f537e;
            }

            .logo-name {
                font-size: 32px;
                color: #000;
                font-weight: 600;
                font-family: ui-sans-serif;
            }
        </style>
    </head>
    <body>
        <header>
            <div class="container px-lg-5" style="margin-top: 10px; margin-bottom: 10px;">
                <div class="row p-4 bg-light rounded-3">
                    <div class="col-lg-12">
                        <p class="fs-6 text-center">
                            <img src = "images/logo.png">
                            <br>
                            <strong>मध्य प्रदेश उच्च न्यायालय  जबल्पुर मुख्य पीठ चतुर्थ श्रेणी कलेक्टर रेट /  आकस्मिक निधि से वेतन भोगी कर्मचारी की सीधी भर्ती 2025 हेतु ऑनलाइन आवेदन पत्र</strong>
                    </div>
                    <div class="caption green-title" style="text-align: right;"> Note - (<span class="error">*</span>)चिन्‍ह से चिन्हित सभी फील्‍ड अनिवार्य है। (Fields marked with (<span class="error">*</span>) are mandatory) </div>
                    <!--<form method="POST" name='regform' id='regform' action="/law-clerk-insert" enctype="multipart/form-data">-->
                        <form method="POST" name='regform' id='regform' action="insert.php" enctype="multipart/form-data">
                        <div class="section-header">व्यक्तिगत विवरण (Personal Details)</div>
                        <div class="col-lg-12">
                            <span style = "color:red"><strong>Note- 1. अभ्यर्थी केवल एक पद वर्ग हेतु ही आवेदन कर सकता है | &nbsp; 2. नाम के आगे (श्री / श्रीमान / श्रीमती / कु / कुमारी) न लगायें |</strong></span>

                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> 
                                   आवेदित पद वर्ग का नाम, जिस हेतु आवेदन कर रहे है (Post Applied)<span class="error">*</span>
                                </div>
                                <div class="col-sm-3 pad-top">
                                    <select name="ddlpost" id="ddlpost" class="form-control  form-select" onchange = "check_llb()">
                                        <option value="0">--Select--</option>
                                        <option value="1">रसोइया</option>
                                        <option value="2">भृत्य</option>
                                        <option value="3">फर्राश</option>
                                        <option value="4">माली</option>
                                    </select> 
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> 
                                    आवेदक / आवेदिका का पूरा नाम<br/>
                                    (Applicant's Full Name)<span class="error">*</span>
                                </div>
                                <div class="col-sm-9 pad-top">
                                    <input type="text" name="name" id="name" style="text-transform:uppercase;" placeholder="आवेदक / आवेदिका का पूरा नाम" onkeyup = "textValidation(this)" class="form-control text" autocomplete="off">
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3 pad-top">
                                    <select name="ddlfather_husband" id="ddlfather_husband" class="form-control  form-select" onchange = "setFH(this)">
                                        <option value="Father">पिता (Father) का नाम</option>
                                        <option value="Husband">पति (Husband) का नाम</option>
                                    </select> 
                                </div>
                                <div class="col-sm-3 pad-top">
                                    <input type="text" name="father_name" id="father_name" style="text-transform:uppercase;" placeholder="पिता का नाम" class="form-control text" autocomplete="off">
                                </div>
                                <div class="col-sm-2">माता का नाम<br/> (Mother's Name) <span class="error">*</span>
                                </div>
                                <div class="col-sm-4 pad-top">
                                    <input type="text" name="mother_name" id="mother_name" style="text-transform:uppercase;" placeholder="माता का नाम" class="form-control text" autocomplete="off">
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> जन्म तिथि (D.O.B.)
                                <span class="error">*</span>
                                </div>
                                <div class="col-sm-3 pad-top">
                                    <input type="date" id="dob" name="dob" class="form-control" maxlength="10" onblur="get_date()"/>
                                </div>
                                <div class="col-sm-2"> लिंग (Gender) <span class="error">*</span>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-control">
                                        <input type="radio" id="male" name="gender" value="Male" class="cursor" onchange="check_radios('gender_msg')">
                                        <label for="male" class="cursor">Male</label>
                                        <input type="radio" id="female" name="gender" value="Female" class="cursor" onchange="check_radios('gender_msg')">
                                        <label for="female" class="cursor">Female</label>
                                        <input type="radio" id="other" name="gender" value="Other" class="cursor" onchange="check_radios('gender_msg')">
                                        <label for="other" class="cursor">Other</label>
                                    </div>
                                    <span id="gender_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> क्या आप शासकीय कर्मचारी है ?<br/>
                                    (Are You Employee of Govt.?)<span class="error">*</span>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-control">
                                        <input type="radio" id="govt_emp_yes" name="govt_emp" value="Yes" class="cursor" onchange="check_radios('govt_emp_msg')">
                                        <label for="govt_emp_yes" class="cursor">Yes</label>
                                        <input type="radio" id="govt_emp_no" name="govt_emp" value="No" class="cursor" onchange="check_radios('govt_emp_msg')">
                                        <label for="govt_emp_no" class="cursor">No</label>
                                    </div>
                                    <span id="govt_emp_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                                <div class="col-sm-2"> जाति वर्ग / श्रेणी<br/> (Category) <span class="error">*</span>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-control">
                                        <input type="radio" id="obc" name="category" class="cursor" value="OBC" onchange="check_radios('category_msg')">
                                        <label for="obc" class="cursor">OBC</label>
                                        <input type="radio" id="st" name="category" class="cursor" value="ST" onchange="check_radios('category_msg')">
                                        <label for="st" class="cursor">ST</label>
                                        <input type="radio" id="sc" name="category" class="cursor" value="SC" onchange="check_radios('category_msg')">
                                        <label for="sc" class="cursor">SC</label>
                                        <input type="radio" id="ur" name="category" class="cursor" value="UR" onchange="check_radios('category_msg')">
                                        <label for="ur" class="cursor">UR</label>
                                    </div>
                                    <span id="category_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> Marital Status <span class="error">*</span>
                                </div>
                                <div class="col-sm-9">
                                    <div class="form-control">
                                        <input type="radio" id="single" name="marital_status" value="Single" class="cursor" onchange="check_radios('marital_msg')">
                                        <label for="single" class="cursor">Single</label>
                                        <input type="radio" id="married" name="marital_status" value="Married" class="cursor" onchange="check_radios('marital_msg')">
                                        <label for="married" class="cursor">Marrired</label>
                                        <input type="radio" id="widow" name="marital_status" value="Widow" class="cursor" onchange="check_radios('marital_msg')">
                                        <label for="widow" class="cursor">Widow</label>
                                        <input type="radio" id="distitute" name="marital_status" value="Distitute" class="cursor" onchange="check_radios('marital_msg')">
                                        <label for="distitute" class="cursor">Distitute</label>
                                        <input type="radio" id="divorcee" name="marital_status" value="Divorcee" class="cursor" onchange="check_radios('marital_msg')">
                                        <label for="divorcee" class="cursor">Divorcee</label>
                                    </div>
                                    <span id="marital_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                            </div>
                            
                            <div class="form-group row top-pad">
                                <div class="col-sm-3">नागरिकता <br/>(Nationality)<span class="error">*</span>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-control">
                                        <input type="radio" id="nationality" name="nationality" value="Indian" class="cursor" onchange="check_radios('nationality_msg')">
                                        <label for="nationality" class="cursor">Indian</label>
                                    </div>
                                    <span id="nationality_msg" class="error" style="display:none;">कृप्या विकल्प का चयन करें |</span>
                                </div>
                                <div class="col-sm-3"> क्या आप म. प्र. के मूल निवासी है ?<br/> (M.P. Domicile ?) <span class="error">*</span>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-control">
                                        <input type="radio" id="domicile_yes" name="domicile" value="Yes" class="cursor" onchange="check_radios('domicile_msg')">
                                        <label for="domicile_yes" class="cursor">Yes</label>
                                        <input type="radio" id="domicile_no" name="domicile" value="No" class="cursor" onchange="check_radios('domicile_msg')">
                                        <label for="domicile_no" class="cursor">No</label>
                                    </div>
                                    <span id="domicile_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                            </div>

                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> मोबाइल नंबर<br/>(Mobile Number) <span class="error">*</span>
                                </div>
                                <div class="col-sm-3 pad-top">
                                    <input type="text" name="mobile_no" id="mobile_no" placeholder="मोबाइल नंबर" maxlength="10" minlength="10"  class="form-control numeric" autocomplete="off"  required/>
                                </div>
                                <span id="mobile_no_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                <div class="col-sm-2">ई-मेल आईडी<br/>(Email ID)<span class="error">*</span>
                                </div>
                                <div class="col-sm-4 pad-top">
                                    <input type="email" name="email" id="email" placeholder="ई-मेल आईडी" class="form-control" autocomplete="off" required>
                                </div>
                            </div>

                        <div class="form-group row top-pad">
                            <div class="col-sm-3">आधार कार्ड का नंबर<br/>(Aadhar Card Number)<span class="error">*</span>
                            </div>
                            <div class="col-sm-3 pad-top">
                                <input type="text" name="aadhar_no" id="aadhar_no" placeholder="आधार कार्ड का नंबर" maxlength="12" minlength="12" class="form-control numeric" autocomplete="off" required>
                            </div>
                            <div class="col-sm-2"> पहचान चिन्ह<br/>(Identity Mark) <span class="error">*</span>
                            </div>
                            <div class="col-sm-4 pad-top">
                                <input type="text" name="identity_mark" id="identity_mark" placeholder="पहचान चिन्ह"  class="form-control text" autocomplete="off"  required/>
                            </div>
                        </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3"> क्या आप शारिरिक विकलांग है ?<br/>(Are You Physically Handicapped) <span class="error">*</span>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-control">
                                        <input type="radio" id="disability_yes" value="Yes" name="disability" class="cursor" onchange="check_radios('disability_msg')">
                                        <label for="disability_yes" class="cursor">Yes</label>
                                        <input type="radio" id="disability_no" value="No" name="disability" class="cursor" onchange="check_radios('disability_msg')">
                                        <label for="disability_no" class="cursor">No</label>
                                    </div>
                                    <span id="disability_msg" class="error" style="display:none;">कृप्या किसी एक विकल्प का चयन करें |</span>
                                </div>
                                <div class="col-sm-2">विकलांगता प्रतिशत<br/>(Handicapped %)<span class="error">*</span>
                                </div>
                                <div class="col-sm-4 pad-top">
                                    <input type="number" name="handicapped_per" id="handicapped_per" placeholder="विकलांगता प्रतिशत" disabled = "disabled" class="form-control" autocomplete="off" required>
                                </div>
                            </div>
                       </div>
                        <div class="section-header">पता (Address)</div>
                        <div class="col-lg-12">
                            <div class="form-group row top-pad">
                                <div class="col-sm-3 ">वर्तमान पता<br/>(Current Address)<span class="error">*</span>
                                </div>
                                <div class="col-sm-9 pad-top">
                                    <textarea id="current_address" name="current_address" placeholder="वर्तमान पता" class="form-control" rows="2" cols="60" autocomplete="off"></textarea>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3 ">पिन कोड<br/>(Pin Code)<span class="error">*</span>
                                </div>
                                <div class="col-sm-3 pad-top">
                                <input type="number" name="current_pin_code" id="current_pin_code" placeholder="वर्तमान पता पिन कोड" class="form-control" autocomplete="off" required>
                                </div>
                                <div class="col-sm-6 pad-top">
                                    <input type="checkbox" name="permanent_addr" id="permanent_addr" value="1" class="cursor" onclick="check_declaration()">
                                    <label for = "permanent_addr" class="cursor">Permanent Address(Same as Current Address)</label>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3 ">स्थायी पता<br/> (Permanent Address) <span class="error">*</span>
                                </div>
                                <div class="col-sm-9 pad-top">
                                    <textarea name="permanent_address" id="permanent_address" placeholder="स्थायी पता" class="form-control" rows="2" cols="60" autocomplete="off"></textarea>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-3 ">पिन कोड<br/>(Pin Code)<span class="error">*</span>
                                </div>
                                <div class="col-sm-3 pad-top">
                                <input type="number" name="permanent_pin_code" id="permanent_pin_code" placeholder="स्थायी पता पिन कोड" class="form-control" autocomplete="off" required>
                                </div>
                            </div>
                        </div>
                        <div class="section-header">शैक्षणिक योग्यता विवरण (Educational Qualification Details)</div>
                        <table style="width:100%;">
                            <tr>
                                <td style="width:5%;border-bottom: thin solid;">क्रमांक<br/>(S.No.)</td>
                                <td style="width:15%;border-bottom: thin solid;" class="txt-center">परीक्षा का नाम<br/>(Exam Name)
                                </td>
                                <td style="width:30%;border-bottom: thin solid;" class="txt-center">बोर्ड/ स्कूल/ संस्थान<br/>(Borad/ School/ Institute)
                                </td>
                                <td style="width:5%;border-bottom: thin solid;" class="txt-center">उत्तीर्ण वर्ष<br/>(Passing.Year)
                                </td>
                                <td style="width:10%;border-bottom: thin solid;" class="txt-center">प्राप्तांकों का प्रतिशत<br/>(Percentage)
                                </td>
                                <td style="width:35%;border-bottom: thin solid;" class="txt-center">टीप यदि कोई हो उत्तीर्ण/ अनुत्तीर्ण<br/>(Remark, if any)
                                </td>
                            </tr>
                            <tr>
                                <td>1.</td>
                                <td>आठवी कक्षा <span class="error">*</span>
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="eight_class" id="eight_class" placeholder="बोर्ड/ स्कूल/ संस्थान" class="form-control" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="eight_pass_year" id="eight_pass_year" maxlength="4" placeholder="उत्तीर्ण वर्ष" class="form-control numeric" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="eight_percentage" id="eight_percentage" maxlength="4"  placeholder="प्रतिशत(%)" class="form-control" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="eight_remarks" id="eight_remarks" maxlength="4"  placeholder="टीप यदि कोई हो" class="form-control" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>2.</td>
                                <td>अन्य कोई शैक्षणिक / तकनिकी योग्यता
                                </td>
                                <td>
                                    <input type="text" name="other_exam" id="other_exam" placeholder="बोर्ड/ स्कूल/ संस्थान" class="form-control" autocomplete="off">
                                </td>
                                <td>
                                    <input type="text" name="other_pass_year" id="other_pass_year"  maxlength="4" placeholder="उत्तीर्ण वर्ष" class="form-control numeric" autocomplete="off">
                                </td>
                                <td>
                                    <input type="text" name="other_percentage" id="other_percentage"  maxlength="4" placeholder="प्रतिशत(%)" class="form-control" autocomplete="off">
                                </td>
                                <td>
                                    <input type="text" name="other_remarks" id="other_remarks"  maxlength="4" placeholder="टीप यदि कोई हो" class="form-control" autocomplete="off">
                                </td>
                            </tr>
                        </table>
                        <div class="section-header">पूर्व अनुभव (Exprience Details)</div>
                        <table style="width:100%;">
                            <tr>
                                <td style="width:5%;" class="bdr-btm">क्रमांक<br/>(S.No.)</td>
                                <td style="width:35%;" class="txt-center bdr-btm">कार्य का अनुभव (यदि कोई हो तो)<br/>(Work Experience (if any))</td>
                                <td style="width:35%;" class="txt-center bdr-btm">कार्यस्थल का पता<br/>(Workplace Address)</td>
                                <td style="width:25%;" class="txt-center bdr-btm">अवधि<br/>(Duration of work) in years</td>
                            </tr>
                            <tr>
                                <td>1.</td>
                                <td class="top-pad">
                                    <input type="text" name="exprience1" id="exprience1" class="form-control" placeholder = "कार्य का अनुभव 1" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="work_address1" id="work_address1" class="form-control" placeholder = "कार्यस्थल का पता 1" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="exprience1_year" id="exprience1_year" class="form-control" placeholder = "अवधि" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>2.</td>
                                <td class="top-pad">
                                    <input type="text" name="exprience2" id="exprience2" class="form-control" placeholder = "कार्य का अनुभव 2" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="work_address2" id="work_address2" class="form-control" placeholder = "कार्यस्थल का पता 2" autocomplete="off">
                                </td>
                                <td class="top-pad">
                                    <input type="text" name="exprience2_year" id="exprience2_year" class="form-control" placeholder = "अवधि" autocomplete="off">
                                </td>
                            </tr>
                        </table>
                        <div class="section-header">Case Details (if any) (प्रकरण की जानकारी यदि कोई हो |)</div>
                        <div class="col-lg-12">
                            <div class="form-group row top-pad">
                                <div class="col-sm-9">
                                    क्या आपके विरुद्ध कोई आपराधिक प्रकरण किसी पुलिस थाने / न्यायालय में अनुसंधान / विचारण हेतु लंबित है अथवा किसी न्यायालय से निराकृत हो चुका है 
                                    यदि हाँ तो संबंधित अधिनियम एवं धारा सहित प्रकरण क्रमांक निर्णय आदि की जानकारी स्पष्ट रूप से अनिवार्यतः उल्लेखित करें |
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-control">
                                        <input type="radio" id="crime_yes" name="crime" value="Yes" class="cursor" onchange="check_domicile()">
                                        <label for="crime_yes" class="cursor">Yes</label>
                                        <input type="radio" id="crime_no" name="crime" value="No" class="cursor" onchange="check_domicile()">
                                        <label for="crime_no" class="cursor">No</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table style="width:100%;border:thin solid">
                            <tr>
                                <td style="width:15%;" class="txt-center">प्रकरण / अपराध क्रमांक<br/>(Crime Number)</td>
                                <td style="width:15%;" class="txt-center">धाराएँ<br/>(Act)</td>
                                <td style="width:30%;" class="txt-center">न्यायालय का नाम<br/>(Court Name)</td>
                                <td style="width:15%;" class="txt-center">नियत / निर्णय दिनांक<br/>(Date)</td>
                                <td style="width:25%;" class="txt-center">रिमार्क / दण्ड<br/>(Remark / Punishment)</td>
                            </tr>
                            <tr>
                                <td class="top-pad" style = "padding-bottom: 8px;">
                                    <input type="text" name="crime_number" id="crime_number" class="form-control" placeholder = "प्रकरण क्रमांक" autocomplete="off">
                                </td>
                                <td class="top-pad" style = "padding-bottom: 8px;">
                                    <input type="text" name="act" id="act" class="form-control" placeholder = "धाराएँ" autocomplete="off">
                                </td>
                                <td class="top-pad" style = "padding-bottom: 8px;">
                                    <input type="text" name="court_name" id="court_name" class="form-control" placeholder = "न्यायालय का नाम" autocomplete="off">
                                </td>
                                <td class="top-pad" style = "padding-bottom: 8px;">
                                    <input type="date" name="decision_date" id="decision_date" class="form-control" autocomplete="off">
                                </td>
                                <td class="top-pad" style = "padding-bottom: 8px;">
                                    <input type="text" name="decision_remarks" id="decision_remarks" class="form-control" placeholder = "रिमार्क / दण्ड" autocomplete="off">
                                </td>
                            </tr>
                        </table>
                        <div class="section-header">दस्तावेज़ अपलोड करें (Upload Your Documents)</div>
                        <div class="col-lg-12">
                            <strong><span class="error">Upload Your Important Documents(As Required like photo, signature, aadhar card, caste ,domicile certificate etc)</span></strong>
                            <div class="form-group row top-pad">
                                <div class="col-sm-6">
                                    Upload your image <span class="error">(Max Size 50KB)</span> 
                                    <br>
                                    <input type="file" name="pic" id="pic" onchange="pic_Validation();" multiple accept="image/jpeg, image/jpg">
                                    <div id="picPreview"></div>
                                </div>
                                <div class="col-sm-6">
                                    Upload your signature <span class="error">(Max Size 50KB)</span> 
                                    <br>
                                    <input type="file" name="sign" id="sign" onchange="sign_Validation(event);" multiple accept="image/jpeg, image/jpg">
                                    <div id="signPreview"></div>
                                </div>
                            </div>  
                            <div class="form-group row top-pad">
                                <div class="col-sm-6">
                                    Upload your aadhar card <span class="error">(Max Size 100KB)</span> 
                                    <br>
                                    <input type="file" name="pic" id="pic" onchange="pic_Validation();" multiple accept="image/jpeg, image/jpg">
                                    <div id="picPreview"></div>
                                </div>
                                <div class="col-sm-6">
                                    Upload your caste certificate <span class="error">(Max Size 100KB)</span> 
                                    <br>
                                    <input type="file" name="sign" id="sign" onchange="sign_Validation(event);" multiple accept="image/jpeg, image/jpg">
                                    <div id="signPreview"></div>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-6">
                                    Upload your domicile certificate <span class="error">(Max Size 100KB)</span> 
                                    <br>
                                    <input type="file" name="pic" id="pic" onchange="pic_Validation();" multiple accept="image/jpeg, image/jpg">
                                    <div id="picPreview"></div>
                                </div>
                            </div>
                        </div>
                        <div class="section-header">घोषणा (Declaration)</div>
                        <div class="form-group row top-pad">
                            <div class="col-sm-2">
                                <span class="caption">Place</span><span class="error">*</span>
                            </div>
                            <div class="col-sm-4"> 
                                <input type="text" name="place" id="place" placeholder="Place" class="form-control" autocomplete="off">
                            </div>
                            <div class="col-sm-2">
                                <span class="caption">Date</span><span class="error">*</span>
                            </div>
                            <div class="col-sm-4"> 
                                <input type="text" name="date" id="date" class="form-control" value ="<?php echo date('d-m-Y'); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group row top-pad">
                                <div class="col-sm-12">
                                    <input type="checkbox" name="declaration" id="declaration" value="1" onclick="check_declaration()">
                                    <strong>मैं यह घोषणा करता / करती हूँ कि मैंने परीक्षा से संबंधित सभी नियमों एवं विज्ञापन को अच्छी तरह से पढ़ व समझ लिया है | उपरोक्त समझ जानकारी मेरे ज्ञान व विश्वास के अनुसार सही व सम्पूर्ण है | 
                                        किसी भी स्तर पर आवेदन में कोई भी जानकारीअसत्य और / अथवा अपूर्ण पाई जाती है अथवा मेरे द्वारा कोई जानकारी छिपाई जाति है तो मेरे विरुद्ध कार्यवाही की जाकर मेरा आवेदन किसी भी प्रक्रम पर निरस्त कर मेरा प्रवेश, 
                                        चयन और अभ्यर्थिता निरस्त की जा सकती है अथवा मुझे पद से हटाया जा सकता है |</strong>
                                    <span id="declaration_msg" class="error" style="display:none;">Please click on the declaration button</span>
                                </div>
                            </div>
                            <div class="form-group row top-pad">
                                <div class="col-sm-12">
                                    <button type="submit" id="btnSubmit" onclick="return validation()" class="btn btn-info"> Submit</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </header>


        <script src="https://code.jquery.com/jquery-1.9.1.min.js"  integrity="sha256-wS9gmOZBqsqWxgIVgA8Y9WcQOa7PgSIX+rPA0VL2rbQ=" crossorigin="anonymous"></script>
    </body>
    <script> 
	$(document).ready(function () {
		$(".numeric").keypress(function (e) {
			if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
				$(".errmsg").html("Digits Only").show().fadeOut("slow");
				return false;
			}
		});
        $(".text").keypress(function (e) {
            if(e.which == 32)
                return true;
           // if(48 <= ew && ew <= 57)
                //return true;
            if(65 <= e.which && e.which <= 90)
                return true;
            if(97 <= e.which && e.which <= 122)
                return true;
            return false;
		});
	});
    function IsEmail(email) {
            const regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if (!regex.test(email)) {
                return false;
            }
            else {
                return true;
            }
        }
    function setFH(ctrl){
        if(father_name.value == "Father"){
            $("#father_name").attr("placeholder", "पिता का नाम");  
        }
        else{
            $("#father_name").attr("placeholder", "पति का नाम");  
        }
    }  

	function check_radios(val){
		if ($('input[name="gender"]:checked').length > 0) {
			$("#"+val).css('display', 'none');
		}
	}

    function check_
	function validation()
	{
		ctrl = $("#ddlpost");
		if (ctrl.val() == '0')
		{
			alert("Please select a post name");
			ctrl.focus();
			return false;
		}
		ctrl = $("#name");
		if (ctrl.val() == '')
		{
			alert("Please enter full name");
			ctrl.focus();
			return false;
		}
		ctrl = $("#father_name");
		if (ctrl.val() == '')
		{
			alert("Please enter father's name");
			ctrl.focus();
			return false;
		}
		ctrl = $("#mother_name");
		if (ctrl.val() == '')
		{
			alert("Please enter mother's name");
			ctrl.focus();
			return false;
		}
		ctrl = $("#dob");
		if (ctrl.val() == '')
		{
			alert("Please enter your date of birth");
			ctrl.focus();
			return false;
		}
		if ($('input[name="gender"]:checked').length === 0) {
			alert("Please select a gender");
			$('input[name="gender"]').focus();
			$("#gender_msg").css('display', 'block');
			return false;
		}
		if ($('input[name="govt_emp"]:checked').length === 0) {
			alert("Are you a goventment employee");
			$('input[name="govt_emp"]').focus();
			$("#govt_emp_msg").css('display', 'block');
			return false;
		}
		if ($('input[name="category"]:checked').length === 0) {
			alert("Please select a category");
			$('input[name="category"]').focus();
			$("#category_msg").css('display', 'block');
			return false;
		}
		if ($('input[name="marital_status"]:checked').length === 0) {
			alert("Please select a marital status");
			$('input[name="marital_status"]').focus();
			$("#marital_msg").css('display', 'block');
			return false;
		}
		if ($('input[name="nationality"]:checked').length === 0) {
			alert("Please select nationality");
			$('input[name="nationality"]').focus();
			$("#nationality_msg").css('display', 'block');
			return false;
		}
		if ($('input[name="domicile"]:checked').length === 0) {
			alert("Please select a domicile option");
			$('input[name="domicile"]').focus();
			$("#domicile_msg").css('display', 'block');
			return false;
		} 
		ctrl = $("#mobile_no");
		if (ctrl.val() == '')
		{
			alert("Please enter your mobile number");
			ctrl.focus();
			return false;
		}
        else if (ctrl.val().length<10)
		{
			alert("Mobile number should contain 10 digits");
			ctrl.focus();
			return false;
        }
		ctrl = $("#email");
		if (ctrl.val() == '')
		{
			alert("Please enter your email");
			ctrl.focus();
			return false;
		}
        else{
            if (IsEmail(ctrl.val()) === false) {
                alert("Please enter a valid email id");
                ctrl.focus();
                return false;
            }
        }
		ctrl = $("#aadhar_no");
		if (ctrl.val() == '')
		{
			alert("Please enter your aadhar number");
			ctrl.focus();
			return false;
		}
		ctrl = $("#identity_mark");
		if (ctrl.val() == '')
		{
			alert("Please enter identity mark");
			ctrl.focus();
			return false;
		}        
		if ($('input[name="disability"]:checked').length === 0) {
			alert("Please select a disability option");
			$('input[name="disability"]').focus();
			$("#disability_msg").css('display', 'block');
			return false;
		} 
        else if ($('input[name="disability"]:checked').value === "Yes") {            
            ctrl = $("#handicapped_per");
            if (ctrl.val() == '')
            {
                alert("Please enter handicapped percentage");
                ctrl.focus();
                return false;
            }   
        }
        
		ctrl = $("#current_address");
		if (ctrl.val() == '')
		{
			alert("Please enter current address");
			ctrl.focus();
			return false;
		}
        
		ctrl = $("#current_pin_code");
		if (ctrl.val() == '')
		{
			alert("Please enter current address pin code");
			ctrl.focus();
			return false;
		}
        
		ctrl = $("#permanent_address");
		if (ctrl.val() == '')
		{
			alert("Please enter permanent address");
			ctrl.focus();
			return false;
		}
        
		ctrl = $("#permanent_pin_code");
		if (ctrl.val() == '')
		{
			alert("Please enter permanent address pin code");
			ctrl.focus();
			return false;
		}

		ctrl = $("#eight_class");
		if (ctrl.val() == '')
		{
			alert("Please enter 8th examination board name");
			ctrl.focus();
			return false;
		}
		ctrl = $("#eight_pass_year");
		if (ctrl.val() == '')
		{
			alert("Please enter 8th passing year");
			ctrl.focus();
			return false;
		}
		ctrl = $("#eight_percentage");
		if (ctrl.val() == '')
		{
			alert("Please enter percentage");
			ctrl.focus();
			return false;
		}
		ctrl = $("#other_exam");
		if (ctrl.val() != '')
		{
            ctrl = $("#other_pass_year");
            if (ctrl.val() == '')
            {
                alert("Please enter passing year");
                ctrl.focus();
                return false;
            }
            ctrl = $("#other_percentage");
            if (ctrl.val() == '')
            {
                alert("Please enter percentage");
                ctrl.focus();
                return false;
            }
		}
		ctrl = $("#exprience1");
		if (ctrl.val() != '')
		{
            ctrl = $("#work_address1");
            if (ctrl.val() == '')
            {
                alert("Please enter work address");
                ctrl.focus();
                return false;
            }
            ctrl = $("#exprience1_year");
            if (ctrl.val() == '')
            {
                alert("Please enter work experience");
                ctrl.focus();
                return false;
            }
		}
		ctrl = $("#exprience2");
		if (ctrl.val() != '')
		{
            ctrl = $("#work_address2");
            if (ctrl.val() == '')
            {
                alert("Please enter work address");
                ctrl.focus();
                return false;
            }
            ctrl = $("#exprience2_year");
            if (ctrl.val() == '')
            {
                alert("Please enter work experience");
                ctrl.focus();
                return false;
            }
		}
		ctrl = $("#llb_exam_uni");
		if (ctrl.val() == '')
		{
			alert("Please enter LL.B. university");
			ctrl.focus();
			return false;
		}
		ctrl = $("#llb_pass_year");
		if (ctrl.val() == '')
		{
			alert("Please enter LL.B. pass year");
			ctrl.focus();
			return false;
		}
		ctrl = $("#llb_percentage");
		if (ctrl.val() == '')
		{
			alert("Please enter percentage in LL.B.");
			ctrl.focus();
			return false;
		}

		ctrl = $("#grad_pass_yearI");
		if (ctrl.val() == '')
		{
			alert("Please enter 1st semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageI");
		if (ctrl.val() == '')
		{
			alert("Please enter 1st semester maximum marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_pass_yearII");
		if (ctrl.val() == '')
		{
			alert("Please enter 2nd semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageII");
		if (ctrl.val() == '')
		{
			alert("Please enter 2nd semester maximum marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_pass_yearIII");
		if (ctrl.val() == '')
		{
			alert("Please enter 3rd semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageIII");
		if (ctrl.val() == '')
		{
			alert("Please enter 3rd semester maximum marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_pass_yearIV");
		if (ctrl.val() == '')
		{
			alert("Please enter 4th semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageIV");
		if (ctrl.val() == '')
		{
			alert("Please enter 4th semester maximum marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageV");
		if (ctrl.val() == '')
		{
			alert("Please enter 5th semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_pass_yearV");
		if (ctrl.val() == '')
		{
			alert("Please enter 5th semester maximum marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_pass_yearVI");
		if (ctrl.val() == '')
		{
			alert("Please enter 6th semester scored marks");
			ctrl.focus();
			return false;
		}
		ctrl = $("#grad_percentageVI");
		if (ctrl.val() == '')
		{
			alert("Please enter 6th semester maximum marks");
			ctrl.focus();
			return false;
		}

		if ($("#ddlgraduation").val() == "B.A. LL.B.")
		{
			ctrl = $("#grad_pass_yearVII");
			if (ctrl.val() == '')
			{
				alert("Please enter 7th semester scored marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_percentageVII");
			if (ctrl.val() == '')
			{
				alert("Please enter 7th semester maximum marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_pass_yearVIII");
			if (ctrl.val() == '')
			{
				alert("Please enter 8th semester scored marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_percentageVIII");
			if (ctrl.val() == '')
			{
				alert("Please enter 8th semester maximum marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_pass_yearIX");
			if (ctrl.val() == '')
			{
				alert("Please enter 9th semester scored marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_percentageIX");
			if (ctrl.val() == '')
			{
				alert("Please enter 9th semester maximum marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_pass_yearX");
			if (ctrl.val() == '')
			{
				alert("Please enter 10th semester scored marks");
				ctrl.focus();
				return false;
			}
			ctrl = $("#grad_percentageX");
			if (ctrl.val() == '')
			{
				alert("Please enter 10th semester maximum marks");
				ctrl.focus();
				return false;
			}
		}
		ctrl = $("#case_details");
		if (ctrl.val() == '')
		{
			alert("Please enter case_details");
			ctrl.focus();
			return false;
		}
		ctrl = $("#Q_Clerk_Cum_Research_Assist");
		if (ctrl.val() == '')
		{
			alert("Please enter Q_Clerk_Cum_Research_Assist");
			ctrl.focus();
			return false;
		}
		ctrl = $("#Q_JudicialService");
		if (ctrl.val() == '')
		{
			alert("Please enter Q_JudicialService");
			ctrl.focus();
			return false;
		}
		ctrl = $("#Q_Judge_Lawyer");
		if (ctrl.val() == '')
		{
			alert("Please enter Q_Judge_Lawyer");
			ctrl.focus();
			return false;
		}
		ctrl = $("#pic");
		if (ctrl.val() == '')
		{
			alert("Please Select pic");
			ctrl.focus();
			return false;
		}
		ctrl = $("#sign");
		if (ctrl.val() == '')
		{
			alert("Please Upload sign");
			ctrl.focus();
			return false;
		}
		ctrl = $("#place");
		if (ctrl.val() == '')
		{
			alert("Please enter place");
			ctrl.focus();
			return false;
		}
		ctrl = $("#date");
		if (ctrl.val() == '')
		{
			alert("Please enter date");
			ctrl.focus();
			return false;
		}
		ctrl = $("#declaration");
		if (ctrl.val() == '')
		{
			alert("Please enter declaration");
			ctrl.focus();
			return false;
		}
	}

    </script>
</html>