@extends('layouts.front.app')

@section('title', 'Send WhatsApp Message')

@section('content')
<div class="container py-4">
    <h2>Send WhatsApp Message</h2>

    @if(session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <form action="{{ route('whatsapp.send') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="to" class="form-label">Recipient Number (with country code)</label>
            <input type="text" name="to" id="to" class="form-control" placeholder="e.g. 919876543210" required value="919685970556">
        </div>

        <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea name="message" value="Hi" id="message" rows="4" class="form-control" required></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Send Message</button>
    </form>
</div>
@endsection
